<?xml version="1.0" encoding="utf-8"?>
	<xsl:stylesheet version="1.0"
	 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	 xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
	 xmlns:rss="http://purl.org/rss/1.0/"
	>

	<xsl:output method="html" encoding="utf-8" />
	<xsl:param name="paramTitle"/>
	<xsl:template match="/">
		<html>
			<head>
				<style type="text/css">
					html
					{
						border: 2px solid gray;
					}
					body
					{
						font-family: Verdana,Sans-serif;
						font-size: 8pt;
						margin: 5px;
						padding: 0;
						color-color: #333333
						background: #ffffff;
					}
					#title
					{
						font-family: Verdana,Sans-serif; 
						font-size: 10pt;
						background-color: #d6dff7;
						padding: 0.3em;
						border-color: #999999;
						border-bottom-width: 1px;
						/* border-bottom-style:dotted; */
					}
					#description
					{
						margin: 3px;
						padding: 0.2em;
					}
					.alignR
					{
						text-align: right;
					}

					img
					{
						vertical-align: middle;
					}
					span
					{
						margin: 10px;
					}
					table
					{
						cellspacing: 0px;
						cellpadding: 0px;
						border: 0px;
					}

					a
					{
						color: #222255;
						text-decoration: none;
						font-weight: bold;
					}
					a:visited
					{
						color: #333333;
						text-decoration:none;
					}
					a:hover
					{
						color: #6b8ade;
						text-decoration: underline;
					}

					#title
					{
						color: #ffffff;
						text-decoration: none;
						padding-bottom: 4px; 
						padding-top:4px;
						font-style:bold;
					}

					div.upgrade_support_text
					{
						font-size: 10.5px;
						text-align: right;
					}

					div.version_text
					{
						margin: 0px;
						margin-left: 16px;
						margin-top: 5px;
						padding: 0px;
						font-size: 11px;
					}

					a.get_plugin, a.get_plugin:visited, a.get_plugin:hover
					{
						color: #0000ff;
						background-color: inherit;
						text-decoration: underline;
					}
				</style>
				<title><xsl:value-of select="$paramTitle"/></title>
			</head>
			<body>
				<div id="title">
					<xsl:text disable-output-escaping="yes">&lt;img src="$PATH$folder.gif" /&gt;</xsl:text>
					<a>
						<xsl:attribute name="href">
							<xsl:value-of select="//rdf:RDF/rss:channel/rss:link"/>
						</xsl:attribute>
						<xsl:value-of select="//rdf:RDF/rss:channel/rss:title" />
					</a>
				</div>
				<table>
					<tr style="height: 2px">
						<td></td>
					</tr>
				</table>
				<div style="font-family:Verdana,Sans-serif; font-size: 8pt; filter: progid:DXImageTransform.Microsoft.Gradient(gradientType=0,startColorStr=#D6DFF7,endColorStr=#EEF5FC);">
					<xsl:apply-templates select="//rdf:RDF/rss:item"/>
				</div>
				<div><br /></div>
				<div class="alignR">
					<a class="get_plugin">
						<xsl:attribute name="href">
							http://rd.lunascape.jp/jp.aspx?id=%7b764633B4-3DD8-4771-8AC4-A6678DC3C16D%7d
						</xsl:attribute>
						获得插件
					</a>
				</div>
			</body>
		</html>
	</xsl:template>

	<xsl:template match="//rdf:RDF/rss:channel/rss:title">
		<xsl:value-of select="."/>
	</xsl:template>

	<xsl:template match="//rdf:RDF/rss:channel/rss:link">
		<xsl:value-of select="."/>
	</xsl:template>

	<xsl:template match="rdf:RDF/rss:item">
		<xsl:if test="position() &gt; 1">
			<tr>
				<td>
					<span style="margin: 0px; padding: 0px; font-size: 11px;">
						<xsl:text disable-output-escaping="yes">&lt;img </xsl:text>
						<xsl:choose>
							<xsl:when test="string-length(rss:IconPath) &gt; 0">
								src="<xsl:value-of select="rss:IconPath"/>" "width="16" height="16"
							</xsl:when>
							<xsl:otherwise>
								src="<xsl:value-of select="rss:image"/>"
							</xsl:otherwise>
						</xsl:choose>
						<xsl:text disable-output-escaping="yes"> /&gt;</xsl:text>

						<a>
							<xsl:attribute name="href">
								<xsl:value-of select="rss:link"/>
							</xsl:attribute>
							<xsl:value-of select="rss:title" />
						</a>
					</span>
					<div class="version_text">
						版本： <xsl:value-of select="rss:PluginVersion"/>
					</div>

					<div>
						<xsl:attribute name="id">description</xsl:attribute>
						<xsl:value-of disable-output-escaping="yes" select="rss:description" />
					</div>

					<xsl:choose>
						<xsl:when test="rss:UpgradeSupported = '0'">
							<div class="upgrade_support_text">
								不支持更新。
							</div>
						</xsl:when>
						<xsl:when test="rss:UpgradeNotFound = '1'">
							<div class="upgrade_support_text">
								 未找到更新。
							</div>
						</xsl:when>
						<xsl:when test="string-length(rss:UpgradePackageUrl) &gt; 0">
							<div class="alignR">
								<a>
									<xsl:attribute name="href">
										<xsl:value-of select="rss:UpgradePackageUrl"/>
									</xsl:attribute>
									[更新此插件]
								</a>
							</div>
						</xsl:when>
						<xsl:otherwise>
							<!--
							<div style="text-align:right;">
								<a>
									[No update]
								</a>
							</div>
							-->
						</xsl:otherwise>
					</xsl:choose>
					<hr/>
				</td>
			</tr>
		</xsl:if>
	</xsl:template>

</xsl:stylesheet>